/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.EntityPoseTrait;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Pose")
@Description(value={"The pose of a Citizens NPC"})
@Since(value={"1.2.1"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"set npc entity pose of last spawned citizen to crouching"})
public class ExprCitizenPose
extends SimplePropertyExpression<NPC, EntityPoseTrait.EntityPose> {
    @Nullable
    public EntityPoseTrait.EntityPose convert(NPC npc) {
        return ((EntityPoseTrait)npc.getOrAddTrait(EntityPoseTrait.class)).getPose();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{EntityPoseTrait.EntityPose.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof EntityPoseTrait.EntityPose) {
            EntityPoseTrait.EntityPose pose = (EntityPoseTrait.EntityPose)delta[0];
            for (NPC npc : (NPC[])this.getExpr().getArray(event)) {
                ((EntityPoseTrait)npc.getOrAddTrait(EntityPoseTrait.class)).setPose(pose);
            }
        }
    }

    @NotNull
    public Class<? extends EntityPoseTrait.EntityPose> getReturnType() {
        return EntityPoseTrait.EntityPose.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "citizen entity pose";
    }

    static {
        ExprCitizenPose.register(ExprCitizenPose.class, EntityPoseTrait.EntityPose.class, (String)"(citizen|npc) [entity] pose", (String)"npcs");
    }
}

