/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import au.nagasonic.skonic.elements.citizens.effects.EffSpawnCitizen;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Last Created Citizen")
@Description(value={"The last created citizen.Only applicable if the citizen is created via this addon. Will not save when server restarts."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.0.5"})
@Examples(value={"spawn a zombie citizen named \"Undead\" at spawn", "set {_e} to last created npc"})
public class ExprLastCreatedCitizen
extends SimpleExpression<NPC> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return true;
    }

    @Nullable
    protected NPC[] get(Event event) {
        if (EffSpawnCitizen.lastSpawnedNPC != null) {
            return new NPC[]{EffSpawnCitizen.lastSpawnedNPC};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends NPC> getReturnType() {
        return NPC.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "last spawned citizen";
    }

    static {
        Skript.registerExpression(ExprLastCreatedCitizen.class, NPC.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"last (spawned|created) (citizen|npc)"});
    }
}

