/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.forcefield;

import au.nagasonic.skonic.elements.forcefield.NPCForcefield;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.ForcefieldTrait;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Forcefield")
@Description(value={"Creates a forcefield around the NPCs with the specified width, height, strength and vertical strength."})
@Since(value={"1.2.1-b1"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"make all npcs have a forcefield with 10 width and 5 height and with 6 strength and 6 vert strength", "wait 1 minute", "remove forcefield of all npcs"})
public class EffCitizenForcefield
extends Effect {
    private Expression<NPC> npcExpr;
    private Expression<NPCForcefield> forcefieldExpr;
    private int pattern;

    protected void execute(Event event) {
        NPC[] npcs = (NPC[])this.npcExpr.getArray(event);
        if (npcs != null) {
            for (NPC npc : npcs) {
                if (npc == null) continue;
                if (this.pattern == 0) {
                    NPCForcefield forcefield = (NPCForcefield)this.forcefieldExpr.getSingle(event);
                    if (forcefield == null) continue;
                    forcefield.setForcefield(npc);
                    continue;
                }
                npc.removeTrait(ForcefieldTrait.class);
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0) {
            return "make " + this.npcExpr.toString(event, debug) + " have forcefield " + this.forcefieldExpr.toString(event, debug);
        }
        return "remove forcefield of " + this.npcExpr.toString(event, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        if (matchedPattern == 0) {
            this.forcefieldExpr = exprs[1];
        }
        this.pattern = matchedPattern;
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenForcefield.class, (String[])new String[]{"make %npcs% have %npcforcefield%", "remove forcefield of %npcs%", "remove %npcs%['s] forcefield"});
    }
}

