/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.forcefield;

import au.nagasonic.skonic.elements.forcefield.CitizenForcefieldCreateEvent;
import au.nagasonic.skonic.elements.forcefield.NPCForcefield;
import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SectionExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import java.util.List;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Forcefield - Create")
@Description(value={"Expression to create a Citizens Forcefield. Default values are 1."})
@Since(value={"1.2.1-b1"})
@Examples(value={"set {_force} to forcefield:", "\tset forcefield width to 3", "\tset forcefield height to 4", "\tset forcefield strength to 1", "\tset forcefield vertical strength to 2", "", "set {_field} to a forcefield with width 2"})
@RequiredPlugins(value={"Citizens"})
public class ExprForcefield
extends SectionExpression<NPCForcefield> {
    private Trigger trigger;
    private Expression<Number> widthExpr;
    private Expression<Number> heightExpr;
    private Expression<Number> strengthExpr;
    private Expression<Number> vertStrengthExpr;

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean delayed, SkriptParser.ParseResult result, @Nullable SectionNode node, @Nullable List<TriggerItem> triggerItems) {
        if (node != null) {
            this.trigger = this.loadCode(node, "create forcefield", null, new Class[]{CitizenForcefieldCreateEvent.class});
        }
        this.widthExpr = exprs[0];
        this.heightExpr = exprs[1];
        this.strengthExpr = exprs[2];
        this.vertStrengthExpr = exprs[3];
        return true;
    }

    protected NPCForcefield @Nullable [] get(Event event) {
        NPCForcefield forcefield = new NPCForcefield(this.widthExpr.getSingle(event) == null ? 1.0 : ((Number)this.widthExpr.getSingle(event)).doubleValue(), this.heightExpr.getSingle(event) == null ? 1.0 : ((Number)this.heightExpr.getSingle(event)).doubleValue(), this.strengthExpr.getSingle(event) == null ? 1.0 : ((Number)this.strengthExpr.getSingle(event)).doubleValue(), this.vertStrengthExpr.getSingle(event) == null ? 1.0 : ((Number)this.vertStrengthExpr.getSingle(event)).doubleValue());
        if (this.trigger != null) {
            CitizenForcefieldCreateEvent createEvent = new CitizenForcefieldCreateEvent(forcefield);
            Variables.withLocalVariables((Event)event, (Event)createEvent, () -> TriggerItem.walk((TriggerItem)this.trigger, (Event)createEvent));
        }
        return new NPCForcefield[]{forcefield};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends NPCForcefield> getReturnType() {
        return NPCForcefield.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "forcefield with width: " + this.widthExpr.toString(event, debug) + " with height: " + this.heightExpr.toString(event, debug) + " with strength: " + this.strengthExpr.toString(event, debug) + " with vertical strength: " + this.vertStrengthExpr.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprForcefield.class, NPCForcefield.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] forcefield [with width %number%[,| and]] [[with] height %number%[,| and]] [[with] strength %number%[,| and]] [[with] vertical strength %number%]"});
        EventValues.registerEventValue(CitizenForcefieldCreateEvent.class, NPCForcefield.class, CitizenForcefieldCreateEvent::getForcefield);
    }
}

