/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.forcefield;

import au.nagasonic.skonic.elements.forcefield.NPCForcefield;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Forcefield Strength")
@Description(value={"The strength of a forcefield"})
@Since(value={"1.2.1-b1"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"set forcefield strength of {_forcefield} to 4"})
public class ExprForcefieldStrength
extends SimplePropertyExpression<NPCForcefield, Number> {
    @Nullable
    public Number convert(NPCForcefield forcefield) {
        return forcefield.getStrength();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof Number) {
            Number strength = (Number)delta[0];
            NPCForcefield field = (NPCForcefield)this.getExpr().getSingle(event);
            if (field != null) {
                field.setStrength(strength.doubleValue());
            }
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "forcefield strength";
    }

    static {
        ExprForcefieldStrength.registerDefault(ExprForcefieldStrength.class, Number.class, (String)"forcefield strength", (String)"npcforcefield");
    }
}

