/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.hitbox;

import au.nagasonic.skonic.elements.hitbox.NPCHitbox;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Hitbox Height")
@Description(value={"The height of a Citizen hitbox."})
@Examples(value={"set hitbox height of {_box} to 3"})
@Since(value={"1.2.2-b1"})
@RequiredPlugins(value={"Citizens"})
public class ExprHitboxHeight
extends SimplePropertyExpression<NPCHitbox, Number> {
    @Nullable
    public Number convert(NPCHitbox hitbox) {
        return Float.valueOf(hitbox.getHeight());
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof Number) {
            Number height = (Number)delta[0];
            NPCHitbox box = (NPCHitbox)this.getExpr().getSingle(event);
            if (box != null) {
                box.setHeight(height.floatValue());
            }
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "hitbox height";
    }

    static {
        ExprHitboxHeight.registerDefault(ExprHitboxHeight.class, Number.class, (String)"hitbox height", (String)"npchitbox");
    }
}

