/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.hitbox;

import au.nagasonic.skonic.elements.hitbox.NPCHitbox;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Hitbox Width")
@Description(value={"The width of a Citizen Hitbox."})
@Since(value={"1.2.2-b1"})
@Examples(value={"set hitbox width of {_hitbox} to 5"})
@RequiredPlugins(value={"Citizens"})
public class ExprHitboxWidth
extends SimplePropertyExpression<NPCHitbox, Number> {
    @Nullable
    public Number convert(NPCHitbox hitbox) {
        return Float.valueOf(hitbox.getWidth());
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof Number) {
            Number width = (Number)delta[0];
            NPCHitbox box = (NPCHitbox)this.getExpr().getSingle(event);
            if (box != null) {
                box.setWidth(width.floatValue());
            }
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "hitbox width";
    }

    static {
        ExprHitboxWidth.registerDefault(ExprHitboxWidth.class, Number.class, (String)"hitbox width", (String)"npchitbox");
    }
}

