/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.items.heads;

import au.nagasonic.skonic.elements.util.HeadUtils;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Head from Name")
@Description(value={"Gets a head by player name"})
@Since(value={"1.0.4"})
@Examples(value={"set helmet of player to head from name \"%player's name%\""})
public class ExprHeadFromName
extends SimpleExpression<ItemStack> {
    private Expression<String> name;

    public boolean init(Expression<?>[] exprs, int i, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        return true;
    }

    @Nullable
    protected ItemStack[] get(Event event) {
        String name = (String)this.name.getSingle(event);
        if (name != null) {
            return new ItemStack[]{HeadUtils.headFromName(name)};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "head from name " + this.name.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprHeadFromName.class, ItemStack.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(head|skull) from name %string%"});
    }
}

