/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.items.heads;

import au.nagasonic.skonic.elements.util.HeadUtils;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="Head from Player")
@Description(value={"Gets a head by player"})
@Since(value={"1.0.4"})
@Examples(value={"set helmet of player to head from player"})
public class ExprHeadFromPlayer
extends SimpleExpression<ItemStack> {
    private Expression<Player> player;

    @Nullable
    protected ItemStack[] get(Event e) {
        if (this.player.getSingle(e) != null && this.player != null) {
            ItemStack item = HeadUtils.headFromName(((Player)this.player.getSingle(e)).getName());
            if (item != null) {
                return new ItemStack[]{item};
            }
            return null;
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "head of " + this.player.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprHeadFromPlayer.class, ItemStack.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(head|skull) from %player%", "%player%['s] (head|skull)"});
    }
}

