/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.items.heads;

import au.nagasonic.skonic.elements.util.HeadUtils;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Head from Value")
@Description(value={"Gets a head by value."})
@Since(value={"1.0.4"})
@Examples(value={"set {_cacti} to head from value \"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMmY1ODViNDFjYTVhMWI0YWMyNmY1NTY3NjBlZDExMzA3Yzk0ZjhmOGExYWRlNjE1YmQxMmNlMDc0ZjQ3OTMifX19\""})
public class ExprHeadFromValue
extends SimpleExpression<ItemStack> {
    private Expression<String> value;

    public boolean init(Expression<?>[] exprs, int i, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.value = exprs[0];
        return true;
    }

    @Nullable
    protected ItemStack[] get(Event event) {
        String ValueString = (String)this.value.getSingle(event);
        if (ValueString != null) {
            ItemStack item = HeadUtils.headFromBase64(ValueString);
            if (item != null) {
                return new ItemStack[]{item};
            }
            return null;
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "head from value " + this.value.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprHeadFromValue.class, ItemStack.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(head|skull) from value %string%"});
    }
}

