/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.items.other;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

@Name(value="Enchanted Book With Enchantments")
@Description(value={"Returns an enchanted book with the given enchantments."})
@Since(value={"1.2.1"})
@Examples(value={"set {_sharpbook} to enchanted book with sharpness 5"})
public class ExprEnchBookWith
extends SimpleExpression<ItemStack> {
    Expression<ItemStack> bookExpr;
    Expression<EnchantmentType> enchantsExpr;

    protected ItemStack @Nullable [] get(Event event) {
        EnchantmentType[] enchs;
        ItemStack input = (ItemStack)this.bookExpr.getSingle(event);
        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)input.getItemMeta();
        for (EnchantmentType ench : enchs = (EnchantmentType[])this.enchantsExpr.getArray(event)) {
            if (meta.hasStoredEnchant(ench.getType())) {
                meta.removeEnchant(ench.getType());
            }
            meta.addStoredEnchant(ench.getType(), ench.getLevel(), true);
        }
        ItemStack result = (ItemStack)this.bookExpr.getSingle(event);
        result.setItemMeta((ItemMeta)meta);
        return new ItemStack[]{result};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return this.bookExpr.toString(event, debug) + " with " + this.enchantsExpr.toString(event, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.bookExpr = exprs[0];
        this.enchantsExpr = exprs[1];
        return true;
    }

    static {
        Skript.registerExpression(ExprEnchBookWith.class, ItemStack.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"%itemstack% (with|containing) %enchantmenttypes%"});
    }
}

