/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.skins;

import au.nagasonic.skonic.elements.skins.Skin;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Change Skin")
@Description(value={"Changes the skin of a player."})
@Since(value={"1.2"})
@Examples(value={"change player's skin to skin from url \"https://www.minecraftskins.com/uploads/skins/2024/12/12/--*ginger-bread-man*----tcer3--22929673.png?v695\""})
public class EffChangeSkin
extends AsyncEffect {
    private Expression<Player> playerExpr;
    private Expression<Skin> skinExpr;

    protected void execute(Event event) {
        if (this.playerExpr != null && this.skinExpr != null) {
            Player player = (Player)this.playerExpr.getSingle(event);
            Skin skin = (Skin)this.skinExpr.getSingle(event);
            if (player != null && skin != null) {
                PlayerProfile profile = player.getPlayerProfile();
                Set properties = profile.getProperties();
                properties.add(new ProfileProperty("textures", skin.getTexture(), skin.getSignature()));
                player.setPlayerProfile(profile);
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "set skin of " + this.playerExpr.toString(event, debug) + " to " + this.skinExpr.toString(event, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.playerExpr = exprs[0];
        this.skinExpr = exprs[1];
        return true;
    }

    static {
        Skript.registerEffect(EffChangeSkin.class, (String[])new String[]{"(change|set) %player%['s] skin to %skin%", "(change|set) skin of %player% to %skin%"});
    }
}

