/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.skins;

import au.nagasonic.skonic.Skonic;
import au.nagasonic.skonic.elements.skins.Skin;
import au.nagasonic.skonic.elements.util.HeadUtils;
import au.nagasonic.skonic.elements.util.Util;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Download Player Skin")
@Description(value={"Downloads a skin"})
@Since(value={"1.0.4"})
@Examples(value={"on join:", "\tdownload player's skin"})
public class EffDownloadPlayerSkin
extends Effect {
    private Expression<Skin> skinExpr;

    protected void execute(Event e) {
        Skin skin = (Skin)this.skinExpr.getSingle(e);
        if (this.skinExpr == null || skin == null) {
            Skonic.log(Level.SEVERE, "The given skin is null, please retry.");
            return;
        }
        String value = skin.getTexture();
        if (value == null) {
            Skonic.log(Level.SEVERE, "The skin does not have a value, please check if the skin entered is correct.");
            return;
        }
        URL url = null;
        try {
            url = HeadUtils.getUrlFromBase64(value);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        if (url == null) {
            Skonic.log(Level.SEVERE, "The skin does not have a skin url. Aborting...");
            return;
        }
        File file = new File(Skonic.getPath() + "/skins/" + Util.fromDate(Util.getDate()).replaceAll(" ", "") + ".png");
        try {
            FileUtils.copyURLToFile((URL)url, (File)file);
        }
        catch (IOException ex) {
            Skonic.log(Level.SEVERE, "There was an error when retrieving the skin from the skin's url.");
            throw new RuntimeException(ex);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "download skin from " + this.skinExpr.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.skinExpr = exprs[0];
        return true;
    }

    static {
        Skript.registerEffect(EffDownloadPlayerSkin.class, (String[])new String[]{"(download|save) %skin%"});
    }
}

