/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.skins;

import au.nagasonic.skonic.elements.skins.Skin;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

@Name(value="Player's Skin")
@Description(value={"Gets the player's skin.Cannot be set, to set, use 'Change Player Skin' effect."})
@Since(value={"1.0.4"})
@Examples(value={"on join:", "\tset {skins::%player's uuid%} to player's skin"})
public class ExprPlayerSkin
extends SimplePropertyExpression<Player, Skin> {
    public Class<? extends Skin> getReturnType() {
        return Skin.class;
    }

    protected String getPropertyName() {
        return "skin of player";
    }

    @Nullable
    public Skin convert(Player player) {
        if (player == null) {
            return null;
        }
        Skin skin = Skin.fromURL("https://sessionserver.mojang.com/session/minecraft/profile/" + player.getUniqueId() + "?unsigned=false");
        if (skin == null) {
            return null;
        }
        return skin;
    }

    static {
        ExprPlayerSkin.register(ExprPlayerSkin.class, Skin.class, (String)"skin", (String)"player");
    }
}

