/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.skins;

import au.nagasonic.skonic.elements.skins.Skin;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Skin from UUID")
@Description(value={"Gets a skin from player's uuid."})
@Since(value={"1.0.4"})
@Examples(value={"set {_skin} to skin from uuid \"%player's uuid%\""})
public class ExprSkinFromUUID
extends SimpleExpression<Skin> {
    private Expression<String> uuidString;

    @Nullable
    protected Skin[] get(Event e) {
        if (this.uuidString == null || this.uuidString.getSingle(e) == null) {
            return null;
        }
        return new Skin[]{Skin.fromURL("https://sessionserver.mojang.com/session/minecraft/profile/" + (String)this.uuidString.getSingle(e) + "?unsigned=false")};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Skin> getReturnType() {
        return Skin.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "skin from uuid " + this.uuidString.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.uuidString = exprs[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprSkinFromUUID.class, Skin.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"skin from uuid %string%"});
    }
}

