/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.skins;

import au.nagasonic.skonic.elements.skins.Skin;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Skin With")
@Description(value={"Used to create a skin."})
@Since(value={"1.0.4"})
@Examples(value={"set {_skin} to skin with value {_value} and signature {_sig}"})
public class ExprSkinWith
extends SimpleExpression<Skin> {
    private Expression<String> valueExpr;
    private Expression<String> signatureExpr;

    @Nullable
    protected Skin[] get(Event e) {
        String value = (String)this.valueExpr.getSingle(e);
        String signature = (String)this.signatureExpr.getSingle(e);
        if (value == null || signature == null) {
            return null;
        }
        return new Skin[]{new Skin(value, signature)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Skin> getReturnType() {
        return Skin.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "skin with value " + this.valueExpr.toString(e, debug) + "and signature " + this.signatureExpr.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.valueExpr = exprs[0];
        this.signatureExpr = exprs[1];
        return true;
    }

    static {
        Skript.registerExpression(ExprSkinWith.class, Skin.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"skin with value %string% and signature %string%"});
    }
}

