/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.skins;

import au.nagasonic.skonic.elements.util.HeadUtils;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.net.MalformedURLException;
import java.net.URL;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="URL In Value")
@Description(value={"Retrieves the url within a skin value"})
@Since(value={"1.0.7"})
@Examples(value={"set {_skinurl} to skin url within value \"value of player's skin\""})
public class ExprURLInValue
extends SimpleExpression<String> {
    private Expression<String> stringExpr;

    @Nullable
    protected String[] get(Event e) {
        String urlString = (String)this.stringExpr.getSingle(e);
        if (urlString == null) {
            return null;
        }
        URL url = null;
        try {
            url = HeadUtils.getUrlFromBase64(urlString);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        return new String[]{url.toString()};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "Url within " + this.stringExpr.toString(e, b);
    }

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.stringExpr = exprs[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprURLInValue.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[skin] url within value %string%"});
    }
}

