/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.util;

import au.nagasonic.skonic.Skonic;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private final Skonic plugin;
    private FileConfiguration config;
    private File configFile;
    public boolean SETTINGS_DEBUG;
    public boolean SETTINGS_UPDATE_CHECKER_ENABLED;

    public Config(Skonic plugin) {
        this.plugin = plugin;
        this.loadConfigFile();
    }

    private void loadConfigFile() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.matchConfig();
        this.loadConfigs();
    }

    private void matchConfig() {
        try {
            boolean hasUpdated = false;
            InputStream stream = this.plugin.getResource(this.configFile.getName());
            assert (stream != null);
            InputStreamReader is = new InputStreamReader(stream);
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)is);
            for (String key : defConfig.getConfigurationSection("").getKeys(true)) {
                if (this.config.contains(key)) continue;
                this.config.set(key, defConfig.get(key));
                hasUpdated = true;
            }
            for (String key : this.config.getConfigurationSection("").getKeys(true)) {
                if (defConfig.contains(key)) continue;
                this.config.set(key, null);
                hasUpdated = true;
            }
            if (hasUpdated) {
                this.config.save(this.configFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean getSetting(String setting) {
        return this.config.getBoolean("settings." + setting);
    }

    private void loadConfigs() {
        this.SETTINGS_DEBUG = this.getSetting("debug");
        this.SETTINGS_UPDATE_CHECKER_ENABLED = this.getSetting("update-checker.enabled");
    }
}

