/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.util;

import au.nagasonic.skonic.Skonic;
import au.nagasonic.skonic.elements.skins.Skin;
import au.nagasonic.skonic.elements.util.SkinUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class HeadUtils {
    @Deprecated
    public static ItemStack headFromName(String name) {
        ItemStack item = HeadUtils.getPlayerSkullItem();
        return HeadUtils.headWithName(item, name);
    }

    @Deprecated
    public static ItemStack headWithName(ItemStack item, String name) {
        HeadUtils.notNull(item, "item");
        HeadUtils.notNull(name, "name");
        URL url = null;
        try {
            url = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            JsonObject object = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            String id = object.get("id").getAsString();
            Skin skin = Skin.fromURL("https://sessionserver.mojang.com/session/minecraft/profile/" + id + "?unsigned=false");
            return HeadUtils.headFromBase64(skin.getTexture());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ItemStack headFromUuid(String id) {
        ItemStack item = HeadUtils.getPlayerSkullItem();
        return HeadUtils.headWithUuid(item, id);
    }

    public static ItemStack headWithUuid(ItemStack item, String id) {
        HeadUtils.notNull(item, "item");
        HeadUtils.notNull(id, "id");
        Skin skin = Skin.fromURL("https://sessionserver.mojang.com/session/minecraft/profile/" + id + "?unsigned=false");
        return HeadUtils.headFromBase64(skin.getTexture());
    }

    public static ItemStack headFromUrl(String url) {
        ItemStack item = HeadUtils.getPlayerSkullItem();
        return HeadUtils.headWithUrl(item, url);
    }

    private static PlayerProfile getProfile(String url) {
        URL urlObject;
        HeadUtils.notNull(url, "url");
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
        PlayerTextures textures = profile.getTextures();
        try {
            urlObject = new URL(url);
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException("Invalid URL", exception);
        }
        textures.setSkin(urlObject);
        profile.setTextures(textures);
        return profile;
    }

    public static ItemStack headWithUrl(ItemStack item, String url) {
        PlayerProfile profile = HeadUtils.getProfile(url);
        Skonic.info(profile.getTextures().getSkin().toString());
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        meta.setOwnerProfile(profile);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static ItemStack headFromBase64(String base64) {
        ItemStack item = HeadUtils.getPlayerSkullItem();
        try {
            return HeadUtils.headWithBase64(item, base64);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL getUrlFromBase64(String base64) throws MalformedURLException {
        String decoded = new String(Base64.getDecoder().decode(base64));
        JsonObject jsonObject = JsonParser.parseString((String)decoded).getAsJsonObject();
        JsonObject textures = jsonObject.get("textures").getAsJsonObject();
        String url = textures.getAsJsonObject("SKIN").get("url").getAsString();
        return new URL(url);
    }

    public static ItemStack headWithBase64(ItemStack item, String base64) throws MalformedURLException {
        HeadUtils.notNull(item, "item");
        HeadUtils.notNull(base64, "base64");
        return HeadUtils.headWithUrl(item, HeadUtils.getUrlFromBase64(base64).toString());
    }

    private static boolean newerApi() {
        try {
            Material.valueOf((String)"PLAYER_HEAD");
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static ItemStack getPlayerSkullItem() {
        if (HeadUtils.newerApi()) {
            return new ItemStack(Material.valueOf((String)"PLAYER_HEAD"));
        }
        return new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
    }

    private static void notNull(Object o, String name) {
        if (o == null) {
            throw new NullPointerException(name + " should not be null!");
        }
    }

    public static String getValue(ItemStack head) {
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        PlayerProfile profile = meta.getOwnerProfile();
        String url = profile.getTextures().getSkin().toString();
        JsonObject data = null;
        try {
            data = SkinUtils.generateFromURL(url, false);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        JsonObject texture = data.get("texture").getAsJsonObject();
        String value = texture.get("value").getAsString();
        return value;
    }

    public static URL getURL(ItemStack head) {
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        PlayerProfile profile = meta.getOwnerProfile();
        URL url = profile.getTextures().getSkin();
        return url;
    }
}

