/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.util;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.log.ErrorQuality;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    private static final String PREFIX = "&7[&9Skonic&7] ";
    private static final String PREFIX_ERROR = "&7[&9Skonic &cERROR&7] ";
    private static final Pattern HEX_PATTERN = Pattern.compile("<#([A-Fa-f\\d]){6}>");
    private static final boolean SKRIPT_IS_THERE = Bukkit.getPluginManager().getPlugin("Skript") != null;
    private static final List<String> DEBUGS = new ArrayList<String>();

    public static String getColString(String string) {
        Matcher matcher = HEX_PATTERN.matcher((CharSequence)string);
        if (SKRIPT_IS_THERE) {
            while (matcher.find()) {
                ChatColor hexColor = ChatColor.of((String)matcher.group().substring(1, matcher.group().length() - 1));
                String before = ((String)string).substring(0, matcher.start());
                String after = ((String)string).substring(matcher.end());
                string = before + hexColor + after;
                matcher = HEX_PATTERN.matcher((CharSequence)string);
            }
        } else {
            string = HEX_PATTERN.matcher((CharSequence)string).replaceAll("");
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static void sendColMsg(CommandSender receiver, String format, Object ... objects) {
        receiver.sendMessage(Util.getColString(String.format(format, objects)));
    }

    public static void log(String format, Object ... objects) {
        String log = String.format(format, objects);
        Bukkit.getConsoleSender().sendMessage(Util.getColString(PREFIX + log));
    }

    public static void skriptError(String format, Object ... objects) {
        String error = String.format(format, objects);
        Skript.error((String)Util.getColString(PREFIX_ERROR + error), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
    }

    public static void debug(String format, Object ... objects) {
        String debug = String.format(format, objects);
        Bukkit.getConsoleSender().sendMessage(Util.getColString(PREFIX_ERROR + debug));
    }

    public static void logLoading(String format, Object ... objects) {
        String form = String.format(format, objects);
        DEBUGS.add(form);
        Util.log(form, new Object[0]);
    }

    public static List<String> getDebugs() {
        return DEBUGS;
    }

    @Nullable
    public static NamespacedKey getMCNamespacedKey(@NotNull String key, boolean error) {
        if (!((String)key).contains(":")) {
            key = "minecraft:" + (String)key;
        }
        return Util.getNamespacedKey((String)key, error);
    }

    @Nullable
    public static NamespacedKey getNamespacedKey(@NotNull String key, boolean error) {
        NamespacedKey namespacedKey;
        block8: {
            if (key.length() > 255) {
                if (error) {
                    Util.skriptError("An invalid key was provided, key must be less than 256 characters: %s", key);
                }
                return null;
            }
            if ((key = key.toLowerCase()).contains(" ")) {
                key = key.replace(" ", "_");
            }
            namespacedKey = null;
            if (key.contains(":")) {
                namespacedKey = NamespacedKey.fromString((String)key);
            } else {
                try {
                    namespacedKey = new NamespacedKey((Plugin)Skonic.getInstance(), key);
                }
                catch (Exception exception) {
                    if (!error) break block8;
                    Util.skriptError(exception.getMessage(), new Object[0]);
                }
            }
        }
        if (namespacedKey == null && error) {
            Util.skriptError("An invalid key was provided, that didn't follow [a-z0-9/._-:]. key: %s", key);
        }
        return namespacedKey;
    }

    public static int[] uuidToIntArray(UUID uuid) {
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        return new int[]{(int)(most >> 32), (int)most, (int)(least >> 32), (int)least};
    }

    public static Date getDate() {
        Date date = new Date();
        return date;
    }

    public static String fromDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss");
        return format.format(date);
    }

    public static boolean isURL(String url) {
        boolean c = false;
        try {
            URL Url = new URL(url);
            c = true;
        }
        catch (MalformedURLException ex) {
            Skript.error((String)"Specified 'URL' is not a valid URL");
            throw new RuntimeException(ex);
        }
        return c;
    }

    public static int[] getElementCount() {
        int[] i = new int[5];
        i[0] = Skript.getEvents().size();
        i[1] = Skript.getEffects().size();
        AtomicInteger exprs = new AtomicInteger();
        Skript.getExpressions().forEachRemaining(e -> exprs.getAndIncrement());
        i[2] = exprs.get();
        i[3] = Skript.getConditions().size();
        i[4] = Skript.getSections().size();
        return i;
    }
}

