/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic;

import au.nagasonic.skonic.AddonLoader;
import au.nagasonic.skonic.Metrics;
import au.nagasonic.skonic.elements.util.Config;
import au.nagasonic.skonic.elements.util.UpdateChecker;
import au.nagasonic.skonic.elements.util.Util;
import ch.njol.skript.Skript;
import ch.njol.skript.util.Version;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class Skonic
extends JavaPlugin {
    static final int[] EARLIEST_VERSION = new int[]{1, 19, 4};
    private static Skonic instance;
    private static Logger logger;
    private Config config;
    public static String path;
    private AddonLoader addonLoader = null;

    public void onEnable() {
        long start = System.currentTimeMillis();
        instance = this;
        logger = this.getLogger();
        path = this.getDataFolder().getPath();
        this.config = new Config(this);
        PluginManager pm = Bukkit.getPluginManager();
        this.addonLoader = new AddonLoader(this);
        if (!this.addonLoader.canLoadPlugin()) {
            pm.disablePlugin((Plugin)this);
            return;
        }
        String version = this.getDescription().getVersion();
        if (version.contains("b")) {
            Util.log("&eThis is a Beta build, things may not work as expected, please report any bugs on GitHub", new Object[0]);
            Util.log("&ehttps://github.com/NagasonicDev/Skonic/issues", new Object[0]);
        }
        new UpdateChecker(this);
        Metrics metrics = new Metrics((Plugin)this, 20479);
        metrics.addCustomChart(new Metrics.DrilldownPie("skript_version", () -> {
            HashMap map = new HashMap();
            Version skriptVersion = Skript.getVersion();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(skriptVersion.toString(), 1);
            map.put((CallSite)((Object)(skriptVersion.getMajor() + "." + skriptVersion.getMinor() + "." + skriptVersion.getRevision())), entry);
            return map;
        }));
        Util.log("&aSuccessfully enabled v%s&7 in &b%.2f seconds", version, Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
    }

    public void onDisable() {
        Util.logLoading("&eDisabled Skonic v%s", this.getDescription().getVersion());
    }

    public Config getPluginConfig() {
        return this.config;
    }

    public static Skonic getInstance() {
        return instance;
    }

    public static void info(String message) {
        logger.info(message);
    }

    public static void log(Level level, String message) {
        logger.log(level, message);
    }

    public static String getPath() {
        return path;
    }
}

