/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Is Flyable")
@Description(value={"Whether a Citizens NPC is flyable."})
@Since(value={"1.2.1-b1"})
@Examples(value={""})
@RequiredPlugins(value={"Citizens"})
public class CondCitizenIsFlyable
extends Condition {
    private Expression<NPC> npcExpr;
    private int pattern;

    public boolean check(Event event) {
        NPC[] npcs = (NPC[])this.npcExpr.getArray(event);
        if (npcs != null) {
            for (NPC npc : npcs) {
                if (npc == null || !(this.pattern == 0 ? !npc.isFlyable() : npc.isFlyable())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0) {
            return "Citizen " + this.npcExpr.toString(event, debug) + " are flyable";
        }
        return "Citizen " + this.npcExpr.toString(event, debug) + " aren't flyable";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.pattern = matchedPattern;
        return true;
    }

    static {
        Skript.registerCondition(CondCitizenIsFlyable.class, (String[])new String[]{"(citizen|npc)[s] %npcs% (is|are|can) fly[able]", "(citizen|npc)[s] %npcs% (is(n't| not)|are(n't| not)|can('t|not| not)) fly[able]"});
    }
}

