/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.ScoreboardTrait;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Is Glowing")
@Description(value={"Checks whether a Citizens NPC is glowing."})
@Since(value={"1.2.2-b1"})
@Examples(value={"if {_npc} is glowing:", "\tbroadcast npc glow colour of {_npc}"})
@RequiredPlugins(value={"Citizens"})
public class CondCitizenIsGlowing
extends Condition {
    private Expression<NPC> npcExpr;
    private Expression<ChatColor> colorExpr;
    private boolean c;
    private int pattern;

    public boolean check(Event event) {
        NPC[] npcs = (NPC[])this.npcExpr.getArray(event);
        if (npcs != null) {
            for (NPC npc : npcs) {
                ChatColor color;
                if (npc == null) continue;
                if (this.pattern == 0) {
                    if (!((Boolean)npc.data().get(NPC.Metadata.GLOWING, (Object)false)).booleanValue()) {
                        return false;
                    }
                    if (!this.c) continue;
                    color = (ChatColor)this.colorExpr.getSingle(event);
                    if (color == null) {
                        return false;
                    }
                    if (((ScoreboardTrait)npc.getOrAddTrait(ScoreboardTrait.class)).getColor() == color) continue;
                    return false;
                }
                if (!((Boolean)npc.data().get(NPC.Metadata.GLOWING, (Object)true)).booleanValue()) {
                    return false;
                }
                if (!this.c || !((Boolean)npc.data().get(NPC.Metadata.GLOWING, (Object)true)).booleanValue()) continue;
                color = (ChatColor)this.colorExpr.getSingle(event);
                if (color == null) {
                    return false;
                }
                if (((ScoreboardTrait)npc.getOrAddTrait(ScoreboardTrait.class)).getColor() != color) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0) {
            return "Citizen " + this.npcExpr.toString(event, debug) + " are glowing";
        }
        return "Citizen " + this.npcExpr.toString(event, debug) + " aren't glowing";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.colorExpr = exprs[1];
        this.pattern = matchedPattern;
        this.c = parseResult.hasTag("c");
        return true;
    }

    static {
        Skript.registerCondition(CondCitizenIsGlowing.class, (String[])new String[]{"(citizen|npc)[s] %npcs% (is|are) glowing [c:%-chatcolor%]", "(citizen|npc)[s] %npcs% (is(n't| not)|are(n't| not)) glowing [c:%-chatcolor%]"});
    }
}

