/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.conditions;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.TargetableTrait;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Is Targetable")
@Description(value={"Make a Citizens NPC targetable by other mobs."})
@Since(value={"1.2"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"if last created npc can be targeted:", "\tmake last created npc not targetable"})
public class CondCitizenIsTargetable
extends Condition {
    private Expression<NPC> npcExpr;
    private int pattern;

    public boolean check(Event event) {
        if (this.npcExpr == null) {
            Skonic.log(Level.SEVERE, "NPC is null");
            return false;
        }
        NPC[] npcs = (NPC[])this.npcExpr.getArray(event);
        if (npcs != null) {
            for (NPC npc : npcs) {
                if (npc == null || !(this.pattern == 0 ? !((TargetableTrait)npc.getOrAddTrait(TargetableTrait.class)).isTargetable() : ((TargetableTrait)npc.getOrAddTrait(TargetableTrait.class)).isTargetable())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString(@Nullable Event event, boolean b) {
        return this.npcExpr.toString(event, b) + " is targetable";
    }

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.pattern = i;
        return true;
    }

    static {
        Skript.registerCondition(CondCitizenIsTargetable.class, (String[])new String[]{"(citizen|npc)[s] %npcs% (is|can be|are) target(able|ed)", "(citizen|npc)[s] %npcs% (is(n't| not)|are(n't| not)|can('t|not be)) target(able|ed)"});
    }
}

