/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.conditions;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Is a Citizen")
@Description(value={"Whether an entity is a Citizens NPC."})
@Since(value={"1.2.1-b2"})
@RequiredPlugins(value={"Citizens"})
public class CondEntityIsCitizen
extends Condition {
    private Expression<LivingEntity> entitiesExpr;
    private int pattern;

    public boolean check(Event event) {
        if (this.entitiesExpr == null) {
            Skonic.log(Level.SEVERE, "Entity/ies are null");
            return false;
        }
        LivingEntity[] entities = (LivingEntity[])this.entitiesExpr.getArray(event);
        if (this.entitiesExpr == null) {
            Skonic.log(Level.SEVERE, "Entity/ies are null");
            return false;
        }
        if (this.pattern == 0) {
            for (LivingEntity entity : entities) {
                if (entity.hasMetadata("NPC")) continue;
                return false;
            }
        } else {
            for (LivingEntity entity : entities) {
                if (!entity.hasMetadata("NPC")) continue;
                return false;
            }
        }
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return null;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entitiesExpr = exprs[0];
        this.pattern = matchedPattern;
        return true;
    }

    static {
        Skript.registerCondition(CondEntityIsCitizen.class, (String[])new String[]{"%livingentities% (is|are) [a[n]] (citizen|npc)[s]", "%livingentities% (is(n't| not)|are(n't|not)) [a[n]] (citizen|npc)[s]"});
    }
}

