/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import au.nagasonic.skonic.Skonic;
import au.nagasonic.skonic.elements.skins.Skin;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.SkinTrait;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Set Citizen Skin - Skin")
@Description(value={"Sets the skin of the npc to the given skin."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.0.7"})
@Examples(value={"set skin of last spawned npc to player's skin", "change npc with id 2's skin to player's skin"})
public class EffChangeCitizenSkin
extends Effect {
    private Expression<NPC> npcExpr;
    private Expression<Skin> skinExpr;

    protected void execute(Event e) {
        String signature;
        String uuid;
        NPC[] npcs = (NPC[])this.npcExpr.getArray(e);
        Skin skin = (Skin)this.skinExpr.getSingle(e);
        if (npcs == null || npcs.length == 0) {
            Skonic.log(Level.INFO, "No NPCs were specified for the skin change.");
            return;
        }
        if (skin == null) {
            Skonic.log(Level.SEVERE, "The specified skin is null, cannot apply skin.");
            return;
        }
        String value = skin.getTexture();
        if (value == null) {
            Skript.error((String)"Specified skin's value is null");
        }
        if ((uuid = String.valueOf(skin.getUUID())) == null) {
            Skript.error((String)"Specified skin's uuid is null");
        }
        if ((signature = skin.getSignature()) == null) {
            Skript.error((String)"Specified skin's signature is null");
        }
        for (NPC npc : npcs) {
            if (npc == null) {
                Skonic.log(Level.WARNING, "Skipping NPC: NPC object is null.");
                continue;
            }
            try {
                SkinTrait trait = (SkinTrait)npc.getOrAddTrait(SkinTrait.class);
                trait.setSkinPersistent(uuid, signature, value);
            }
            catch (Exception ex) {
                Skonic.log(Level.SEVERE, "Failed to set skin for NPC ('" + npc.getId() + "'). Error details:\n" + ex.getMessage());
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "change skin of citizens " + this.npcExpr.toString(e, debug) + " to skin " + this.skinExpr.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.skinExpr = exprs[1];
        return true;
    }

    static {
        Skript.registerEffect(EffChangeCitizenSkin.class, (String[])new String[]{"(change|set) (npc|citizen)[s] %npcs%['s] skin to %skin%", "(change|set) skin of (npc|citizen)[s] %npcs% to %skin%"});
    }
}

