/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.SkinTrait;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

@Name(value="Set Citizen Skin - Name")
@Description(value={"Set a citizen's skin by name.Only works if citizen is a player."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.0.0"})
@Examples(value={"set skin of last spawned npc to \"Nagasonic\""})
public class EffChangeCitizenSkinName
extends AsyncEffect {
    private Expression<NPC> npcExpr;
    private Expression<String> name;

    protected void execute(Event e) {
        NPC[] npcs = (NPC[])this.npcExpr.getArray(e);
        String skinName = (String)this.name.getSingle(e);
        if (npcs == null || npcs.length == 0) {
            Skonic.log(Level.INFO, "No NPCs were specified for the skin change.");
            return;
        }
        if (skinName == null) {
            Skonic.log(Level.SEVERE, "The specified skin name is null, cannot apply skin.");
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)Skonic.getInstance(), () -> {
            for (NPC npc : npcs) {
                if (npc == null) {
                    Skonic.log(Level.WARNING, "Skipping NPC: NPC object is null.");
                    continue;
                }
                try {
                    SkinTrait trait = (SkinTrait)npc.getOrAddTrait(SkinTrait.class);
                    trait.setShouldUpdateSkins(true);
                    trait.setSkinName(skinName);
                }
                catch (Exception ex) {
                    Skonic.log(Level.SEVERE, "Failed to set skin for NPC ('" + npc.getId() + "'). Error details:\n" + ex.getMessage());
                }
            }
        });
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "change skin of citizen with id " + this.npcExpr.toString(e, debug) + " to name " + this.name.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.name = exprs[1];
        return true;
    }

    static {
        Skript.registerEffect(EffChangeCitizenSkinName.class, (String[])new String[]{"(set|change) (citizen|npc)[s] %npcs%['s] skin to %string%", "(set|change) skin of (citizen|npc)[s] %npcs% to %string%"});
    }
}

