/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import au.nagasonic.skonic.Skonic;
import au.nagasonic.skonic.elements.util.SkinUtils;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.google.gson.JsonObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.SkinTrait;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Set Citizen Skin - URL")
@Description(value={"Sets the citizen with the id specified to the skin linked on the url."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.0.0"})
@Examples(value={"set skin of last spawned npc to url \"https://www.minecraftskins.com/uploads/skins/2024/12/12/--*ginger-bread-man*----tcer3--22929673.png?v695\""})
public class EffChangeCitizenSkinURL
extends Effect {
    private Expression<NPC> npcExpr;
    private Expression<String> urlExpr;

    protected void execute(Event e) {
        JsonObject data;
        NPC[] npcs = (NPC[])this.npcExpr.getArray(e);
        String url = (String)this.urlExpr.getSingle(e);
        if (npcs == null || npcs.length == 0) {
            Skript.error((String)"No citizens found to change the skin of.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return;
        }
        if (url == null) {
            Skript.error((String)"Specified URL is null.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return;
        }
        if (!Skonic.getInstance().isEnabled()) {
            Skonic.log(Level.WARNING, "Plugin is disabled. Skipping citizen skin change task for URL: ('" + url + "').");
            return;
        }
        CompletableFuture<JsonObject> skinDataFuture = CompletableFuture.supplyAsync(() -> {
            try {
                URL urlObject = new URL(url);
                String urlString = urlObject.toString();
                if (!urlString.contains("https://www.minecraftskins.com") && !urlString.contains("http://textures.minecraft.net")) {
                    return null;
                }
                return SkinUtils.generateFromURL(url, false);
            }
            catch (InterruptedException | MalformedURLException | ExecutionException ex) {
                Skonic.log(Level.SEVERE, "Error retrieving skin from URL: ('" + url + "'). Error details:\n" + ex);
                return null;
            }
        });
        try {
            data = skinDataFuture.join();
        }
        catch (Exception ex) {
            Skript.error((String)("An error occurred during asynchronous skin retrieval for URL: ('" + url + "')."));
            return;
        }
        if (data == null) {
            Skonic.log(Level.SEVERE, "Skin retrieval failed for URL: ('" + url + "').");
            Skript.error((String)"Skin retrieval failed to get data.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return;
        }
        String uuid = data.get("uuid").getAsString();
        JsonObject texture = data.get("texture").getAsJsonObject();
        String textureEncoded = texture.get("value").getAsString();
        String signature = texture.get("signature").getAsString();
        for (NPC npc : npcs) {
            if (npc == null) {
                Skonic.log(Level.WARNING, "Skipping NPC: NPC object is null.");
                continue;
            }
            try {
                SkinTrait trait = (SkinTrait)npc.getOrAddTrait(SkinTrait.class);
                trait.setSkinPersistent(uuid, signature, textureEncoded);
                Skonic.log(Level.INFO, "Set skin of citizen with id " + npc.getId() + " to " + url);
            }
            catch (Exception ex) {
                Skonic.log(Level.SEVERE, "Failed to set skin for NPC ('" + npc.getId() + "') to ('" + url + "'). Error details:\n" + ex.getMessage());
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "change skin of citizens " + this.npcExpr.toString(e, debug) + " to url " + this.urlExpr.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.urlExpr = exprs[1];
        return true;
    }

    static {
        Skript.registerEffect(EffChangeCitizenSkinURL.class, (String[])new String[]{"(change|set) (npc|citizen)[s] %npcs%['s] skin to url %string%", "(change|set) skin of (npc|citizen)[s] %npcs% to url %string%"});
    }
}

