/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.Collection;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.StatusMapper;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="Make Citizen Break Block")
@Description(value={"Make a Citizens NPC break a block in a radius.", "Radius is how close the npc has to be to break the block."})
@Since(value={"1.2"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"make citizen with id 2 break {_block} with radius 3"})
public class EffCitizenBlockBreak
extends AsyncEffect {
    private Expression<NPC> npcExpr;
    private Expression<Block> blockExpr;
    private Expression<Number> radiiExpr;

    protected void execute(Event event) {
        if (this.npcExpr != null && this.blockExpr != null) {
            NPC npc = (NPC)this.npcExpr.getSingle(event);
            Block block = (Block)this.blockExpr.getSingle(event);
            if (npc != null && block != null) {
                BlockBreaker.BlockBreakerConfiguration cfg = new BlockBreaker.BlockBreakerConfiguration();
                if (this.radiiExpr != null) {
                    Number radius = (Number)this.radiiExpr.getSingle(event);
                    cfg.radius(radius.doubleValue());
                } else {
                    cfg.radius(-1.0);
                }
                if (npc.getEntity() instanceof InventoryHolder) {
                    cfg.blockBreaker((block1, itemstack) -> {
                        Inventory inventory = ((InventoryHolder)npc.getEntity()).getInventory();
                        Location location = npc.getEntity().getLocation();
                        Collection drops = block.getDrops(itemstack);
                        block1.setType(Material.AIR);
                        for (ItemStack drop : drops) {
                            for (ItemStack unadded : inventory.addItem(new ItemStack[]{drop}).values()) {
                                location.getWorld().dropItemNaturally(npc.getEntity().getLocation(), unadded);
                            }
                        }
                    });
                }
                BlockBreaker breaker = npc.getBlockBreaker(block, cfg);
                npc.getDefaultGoalController().addBehavior(StatusMapper.singleUse((Behavior)breaker), 1);
            }
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        if (this.radiiExpr == null) {
            return "make " + this.npcExpr.toString(event, b) + " break " + this.blockExpr.toString(event, b);
        }
        return "make " + this.npcExpr.toString(event, b) + " break " + this.blockExpr.toString(event, b) + " with radius " + this.radiiExpr.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.blockExpr = exprs[1];
        if (parseResult.hasTag("radius")) {
            this.radiiExpr = exprs[2];
        }
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenBlockBreak.class, (String[])new String[]{"make %npc% break %block% [with radius %number%]"});
    }
}

