/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.ScoreboardTrait;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Start/Stop Glowing")
@Description(value={"Makes a Citizens NPC start or stop glowing, with color."})
@Since(value={"1.2.2-b1"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"make all npcs start glowing with color red"})
public class EffCitizenGlow
extends AsyncEffect {
    private Expression<NPC> npcsExpr;
    private Expression<ChatColor> colorExpr;
    private boolean not;
    private boolean c;

    protected void execute(Event e) {
        ChatColor color;
        NPC[] npcs = (NPC[])this.npcsExpr.getArray(e);
        ChatColor chatColor = color = this.c ? (ChatColor)this.colorExpr.getSingle(e) : null;
        if (npcs == null || npcs.length == 0) {
            Skonic.log(Level.INFO, "No NPCs were specified for the glow effect.");
            return;
        }
        if (this.c && color == null) {
            Skonic.log(Level.SEVERE, "Glow color was requested but the expression returned null.");
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)Skonic.getInstance(), () -> {
            for (NPC npc : npcs) {
                if (npc == null) {
                    Skonic.log(Level.WARNING, "Skipping NPC: NPC object is null.");
                    continue;
                }
                try {
                    npc.data().setPersistent(NPC.Metadata.GLOWING, (Object)this.not);
                    if (!this.c) continue;
                    ScoreboardTrait trait = (ScoreboardTrait)npc.getOrAddTrait(ScoreboardTrait.class);
                    trait.setColor(color);
                }
                catch (Exception ex) {
                    Skonic.log(Level.SEVERE, "Failed to set glow/color for NPC ('" + npc.getId() + "'). Error details:\n" + ex.getMessage());
                }
            }
        });
    }

    public String toString(@Nullable Event event, boolean debug) {
        return !this.not ? "make " + this.npcsExpr.toString(event, debug) + " stop glowing" : "make " + this.npcsExpr.toString(event, debug) + " start glowing";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcsExpr = exprs[0];
        this.colorExpr = exprs[1];
        this.not = !parseResult.hasTag("stop");
        this.c = parseResult.hasTag("c");
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenGlow.class, (String[])new String[]{"make %npcs% (start|:stop) glowing [c:[with colo[u]r] %-chatcolor%]", "(start|:stop) %npcs% [from] glowing [c:[with colo[u]r] %-chatcolor%]"});
    }
}

