/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Pathfind")
@Description(value={"Makes the citizen attempt to pathfind to the given location.If that location is linked to an entity, it will not move with the entity."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.0.7, 1.2.2-b1 (straight line)"})
@Examples(value={"make all npcs pathfind to player"})
public class EffCitizenPathfind
extends Effect {
    private Expression<NPC> npcExpr;
    private Expression<Location> locExpr;
    private boolean s;

    protected void execute(Event e) {
        Location loc = (Location)this.locExpr.getSingle(e);
        NPC[] npcs = (NPC[])this.npcExpr.getArray(e);
        if (loc != null && npcs != null) {
            for (NPC npc : npcs) {
                if (npc != null) {
                    if (this.s) {
                        npc.getNavigator().setStraightLineTarget(loc);
                        continue;
                    }
                    npc.getNavigator().setTarget(loc);
                    continue;
                }
                Skonic.log(Level.SEVERE, "NPC cannot be null");
            }
        } else {
            Skonic.log(Level.SEVERE, "Location or NPCS cannot be null.");
        }
    }

    public String toString(@Nullable Event e, boolean b) {
        return "make citizens " + this.npcExpr.toString(e, b) + " pathfind to " + this.locExpr.toString(e, b);
    }

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.locExpr = exprs[1];
        this.s = parseResult.hasTag("s");
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenPathfind.class, (String[])new String[]{"make (citizen|npc) %npcs% (pathfind|move|walk) to[wards] %location% [s:in [a] [straight] line]"});
    }
}

