/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Pause Citizen")
@Description(value={"Pauses or unpauses the citizens if they are navigating."})
@Since(value={"1.2"})
@Examples(value={"if all citizens are paused:", "\tunpause all citizens"})
@RequiredPlugins(value={"Citizens"})
public class EffCitizenPause
extends AsyncEffect {
    private Expression<NPC> npcExpr;
    private boolean pause;

    protected void execute(Event event) {
        NPC[] npcs;
        if (this.npcExpr != null && (npcs = (NPC[])this.npcExpr.getArray(event)) != null) {
            for (NPC npc : npcs) {
                npc.getNavigator().setPaused(!this.pause);
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return null;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.pause = parseResult.hasTag("not");
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenPause.class, (String[])new String[]{"[not:un]pause [the] [[citizen|npc] navigation] [of] %npcs%"});
    }
}

