/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.trait.TargetableTrait;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Make Citizen Targetable")
@Description(value={"Make a citizen targetable to other mobs.", "Or you can stop this process."})
@Examples(value={"make npc with id 2 targetable", "make npc with id 3 not targetable"})
@Since(value={"1.2, 1.2.2-b1 (temporary)"})
@RequiredPlugins(value={"Citizens"})
public class EffCitizenTargetable
extends Effect {
    private int pattern;
    private Expression<NPC> npcExpr;
    private boolean t;

    protected void execute(Event event) {
        if (this.npcExpr != null) {
            NPC npc = (NPC)this.npcExpr.getSingle(event);
            if (npc != null) {
                if (this.pattern == 0) {
                    ((TargetableTrait)npc.getOrAddTrait(TargetableTrait.class)).setTargetable(true);
                } else {
                    ((TargetableTrait)npc.getOrAddTrait(TargetableTrait.class)).setTargetable(false);
                }
                if (this.pattern == 0 && ((MobType)npc.getOrAddTrait(MobType.class)).getType() == EntityType.PLAYER && npc.shouldRemoveFromPlayerList()) {
                    if (this.t) {
                        npc.data().set(NPC.Metadata.REMOVE_FROM_PLAYERLIST, (Object)false);
                    } else {
                        npc.data().setPersistent(NPC.Metadata.REMOVE_FROM_PLAYERLIST, (Object)false);
                    }
                    if (npc.isSpawned()) {
                        NMS.addOrRemoveFromPlayerList((Entity)npc.getEntity(), (boolean)false);
                    }
                }
            } else {
                Skonic.log(Level.SEVERE, "NPC cannot be null");
            }
        } else {
            Skonic.log(Level.SEVERE, "NPC Expression cannot be null");
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        if (this.pattern == 0) {
            return "make " + this.npcExpr.toString(event, b) + " targetable";
        }
        return "make " + this.npcExpr.toString(event, b) + " not targetable";
    }

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.pattern = i;
        this.npcExpr = exprs[0];
        this.t = parseResult.hasTag("t");
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenTargetable.class, (String[])new String[]{"make (citizen|npc) %npc% [[able to] be] target(ed|able) [t:temporarily]", "make (citizen|npc) %npc% not [[able to] be] target(ed|able) [t:temporarily]"});
    }
}

