/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Despawn/Respawn Citizen")
@Description(value={"Despawn or respawn a citizen."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.0.5"})
@Examples(value={"despawn all npcs", "wait 2 seconds", "respawn all npcs at player"})
public class EffDespawnCitizen
extends AsyncEffect {
    private int pattern;
    private Expression<NPC> npcs;
    private Expression<Location> loc;

    protected void execute(Event e) {
        Location location = this.loc != null ? (Location)this.loc.getSingle(e) : null;
        for (NPC npc : (NPC[])this.npcs.getArray(e)) {
            if (this.pattern == 0) {
                npc.despawn(DespawnReason.PLUGIN);
                continue;
            }
            if (location == null) continue;
            npc.spawn(location, SpawnReason.PLUGIN);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "despawn " + this.npcs.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        if (this.pattern == 1) {
            this.loc = Direction.combine(exprs[1], exprs[2]);
        }
        this.npcs = exprs[0];
        return true;
    }

    static {
        Skript.registerEffect(EffDespawnCitizen.class, (String[])new String[]{"[citizens|npc] despawn %npcs%", "[citizens|npc] respawn %npcs% %direction% %location%"});
    }
}

