/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.Age;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Lock Citizen Age")
@Description(value={"Stops the aging process of a Citizens NPC"})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.2.3-b1"})
@Examples(value={"lock all npcs age", "unlock the age of all citizens"})
public class EffLockAge
extends AsyncEffect {
    private Expression<NPC> npcsExpr;
    private boolean un;

    protected void execute(Event event) {
        NPC[] npcs;
        if (this.npcsExpr != null && (npcs = (NPC[])this.npcsExpr.getArray(event)) != null) {
            for (NPC npc : npcs) {
                if (npc == null) continue;
                ((Age)npc.getOrAddTrait(Age.class)).setLocked(!this.un);
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return (this.un ? "unlock" : "lock") + "age of " + this.npcsExpr.toString(event, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcsExpr = exprs[0];
        this.un = parseResult.hasTag("n");
        return true;
    }

    static {
        Skript.registerEffect(EffLockAge.class, (String[])new String[]{"[n:un]lock %npcs%['s] age", "[n:un]lock [the] age of %npcs%"});
    }
}

