/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Spawn Citizen")
@Description(value={"Spawn a customisable citizen with:", "* Name", "* Direction", "* Location", "* Entity Type"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"spawn a zombie citizen named \"Undead\" at spawn"})
@Since(value={"1.0.0"})
public class EffSpawnCitizen
extends Effect {
    public static NPC lastSpawnedNPC;
    private Expression<String> name;
    private Expression<Location> location;
    private Expression<EntityData<?>> type;

    public boolean init(Expression<?>[] exprs, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.type = exprs[0];
        this.name = exprs[1];
        this.location = Direction.combine(exprs[2], exprs[3]);
        return true;
    }

    public String toString(@Nullable Event evt, boolean arg1) {
        if (this.type != null) {
            return "Created NPC named: " + this.name.toString(evt, arg1) + " Location: " + this.location.toString(evt, arg1) + " Type:" + this.type.toString();
        }
        return "Created NPC named: " + this.name.toString(evt, arg1) + " Location: " + this.location.toString(evt, arg1) + " Type: Player";
    }

    public void execute(Event evt) {
        NPC npc;
        EntityData data;
        if (this.location == null || this.location.getSingle(evt) == null) {
            Skonic.log(Level.SEVERE, "The specified location is null");
        }
        EntityType CitizenType = EntityType.PLAYER;
        if (this.type != null && (data = (EntityData)this.type.getSingle(evt)) != null) {
            CitizenType = EntityUtils.toBukkitEntityType((EntityData)data);
        }
        String citizenName = this.name != null && this.name.getSingle(evt) != null ? (String)this.name.getSingle(evt) : "";
        Location location = (Location)this.location.getSingle(evt);
        lastSpawnedNPC = npc = CitizensAPI.getNPCRegistry().createNPC(CitizenType, citizenName, location);
    }

    static {
        Skript.registerEffect(EffSpawnCitizen.class, (String[])new String[]{"spawn [a[n]] [%-entitydata%] (citizen|npc) [named %string%] %direction% %location%"});
    }
}

