/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.Age;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Age")
@Description(value={"The age of a citizen.", "- Ordered between -24000 and 0. Any negative integer being a baby, and 0 being an adult."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.2.3-b1"})
@Examples(value={"set {_age} to npc age of last created citizen", "# BABY", "set npc age of npc with id 2 to -24000"})
public class ExprCitizenAge
extends SimplePropertyExpression<NPC, Number> {
    @Nullable
    public Number convert(NPC npc) {
        return ((Age)npc.getOrAddTrait(Age.class)).getAge();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof Number) {
            Number age = (Number)delta[0];
            for (NPC npc : (NPC[])this.getExpr().getArray(event)) {
                Age trait = (Age)npc.getOrAddTrait(Age.class);
                trait.setAge(age.intValue());
            }
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "citizen age";
    }

    static {
        ExprCitizenAge.register(ExprCitizenAge.class, Number.class, (String)"(citizen|npc) age", (String)"npcs");
    }
}

