/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.ScoreboardTrait;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Glow Color")
@Description(value={"The glow color of a Citizens NPC, in the Chat Color class."})
@Since(value={"1.2.2-b1"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"set the npc glow colour of all citizens to red"})
public class ExprCitizenGlowColor
extends SimplePropertyExpression<NPC, ChatColor> {
    @Nullable
    public ChatColor convert(NPC npc) {
        return ((ScoreboardTrait)npc.getOrAddTrait(ScoreboardTrait.class)).getColor();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ChatColor.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof ChatColor) {
            ChatColor color = (ChatColor)delta[0];
            for (NPC npc : (NPC[])this.getExpr().getArray(event)) {
                ((ScoreboardTrait)npc.getOrAddTrait(ScoreboardTrait.class)).setColor(color);
            }
        }
    }

    @NotNull
    public Class<? extends ChatColor> getReturnType() {
        return ChatColor.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "citizen glow color";
    }

    static {
        ExprCitizenGlowColor.register(ExprCitizenGlowColor.class, ChatColor.class, (String)"(citizen|npc) glow colo[u]r", (String)"npcs");
    }
}

