/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.Gravity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Gravity")
@Description(value={"Whether the Citizens NPC is affected by gravity"})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.2.2-b1"})
@Examples(value={"set the npc gravity of all npcs to true"})
public class ExprCitizenGravity
extends SimplePropertyExpression<NPC, Boolean> {
    @Nullable
    public Boolean convert(NPC npc) {
        return ((Gravity)npc.getOrAddTrait(Gravity.class)).hasGravity();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof Boolean) {
            Boolean hasGravity = (Boolean)delta[0];
            for (NPC npc : (NPC[])this.getExpr().getArray(event)) {
                ((Gravity)npc.getOrAddTrait(Gravity.class)).setHasGravity(hasGravity.booleanValue());
            }
        }
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "citizen gravity";
    }

    static {
        ExprCitizenGravity.register(ExprCitizenGravity.class, Boolean.class, (String)"(citizen|npc) gravity", (String)"npcs");
    }
}

