/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Target")
@Description(value={"The target of a Citizens NPC. Setting is done via the Citizen Attack effect."})
@Since(value={"1.2.2"})
@Examples(value={"make {_npc} attack player", "broadcast npc target of {_npc}"})
@RequiredPlugins(value={"Citizens"})
public class ExprCitizenTarget
extends SimplePropertyExpression<NPC, Entity> {
    @Nullable
    public Entity convert(NPC npc) {
        return npc.getNavigator().getEntityTarget().getTarget();
    }

    protected String getPropertyName() {
        return "citizen target";
    }

    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    static {
        ExprCitizenTarget.register(ExprCitizenTarget.class, Entity.class, (String)"(citizen|npc) target", (String)"npc");
    }
}

