/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen With ID")
@Description(value={"Gets the citizen with the given ID"})
@Examples(value={"set {_npc} to citizen with id 2"})
@Since(value={"1.0.7"})
@RequiredPlugins(value={"Citizens"})
public class ExprCitizenWith
extends SimpleExpression<NPC> {
    private Expression<Number> idExpr;

    @Nullable
    protected NPC[] get(Event e) {
        Integer id = ((Number)this.idExpr.getSingle(e)).intValue();
        if (id != null) {
            NPC npc = CitizensAPI.getNPCRegistry().getById(id.intValue());
            if (npc != null) {
                return new NPC[]{npc};
            }
            Skonic.log(Level.SEVERE, "There is no Citizen with ID " + id);
        } else {
            Skonic.log(Level.SEVERE, "ID cannot be null.");
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends NPC> getReturnType() {
        return NPC.class;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "citizen with id " + this.idExpr.toString(e, b);
    }

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.idExpr = exprs[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprCitizenWith.class, NPC.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(citizen|npc) with id %number%"});
    }
}

