/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.LookClose;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Look Close")
@Description(value={"The look close trait of the citizen.", "Whether the citizen should or should not look at the closest player."})
@Examples(value={"set look close trait of {_npc} to true"})
@Since(value={"1.1"})
@RequiredPlugins(value={"Citizens"})
public class ExprLookClose
extends SimplePropertyExpression<NPC, Boolean> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Boolean convert(NPC npc) {
        return npc.hasTrait(LookClose.class);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof Boolean) {
            Boolean look = (Boolean)delta[0];
            for (NPC npc : (NPC[])this.getExpr().getArray(event)) {
                LookClose close = (LookClose)npc.getOrAddTrait(LookClose.class);
                close.lookClose(look.booleanValue());
            }
        }
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "citizen look close trait";
    }

    static {
        ExprLookClose.register(ExprLookClose.class, Boolean.class, (String)"look close [trait]", (String)"npcs");
    }
}

