/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Name")
@Description(value={"Get the name of a citizen"})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.0.5"})
@Examples(value={"set citizen name of last created npc to \"Nagasonic\""})
public class ExprNameOfCitizen
extends SimplePropertyExpression<NPC, String> {
    @Nullable
    public String convert(NPC npc) {
        return npc.getName();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof String) {
            String name = (String)delta[0];
            for (NPC npc : (NPC[])this.getExpr().getArray(event)) {
                npc.setName(name);
                Location loc = npc.getEntity().getLocation();
                npc.despawn();
                npc.spawn(loc);
            }
        }
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "citizen name";
    }

    static {
        ExprNameOfCitizen.register(ExprNameOfCitizen.class, String.class, (String)"(citizen|npc) name", (String)"npcs");
    }
}

