/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.forcefield;

import au.nagasonic.skonic.elements.forcefield.NPCForcefield;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Forcefield Height")
@Description(value={"The height of a forcefield."})
@Since(value={"1.2.1-b1"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"set npc with id 2's npc forcefield height to 3"})
public class ExprForcefieldHeight
extends SimplePropertyExpression<NPCForcefield, Number> {
    @Nullable
    public Number convert(NPCForcefield forcefield) {
        return forcefield.getHeight();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof Number) {
            Number height = (Number)delta[0];
            NPCForcefield field = (NPCForcefield)this.getExpr().getSingle(event);
            if (field != null) {
                field.setHeight(height.doubleValue());
            }
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "forcefield height";
    }

    static {
        ExprForcefieldHeight.registerDefault(ExprForcefieldHeight.class, Number.class, (String)"forcefield height", (String)"npcforcefield");
    }
}

