/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.forcefield;

import au.nagasonic.skonic.elements.forcefield.NPCForcefield;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Forcefield Vertical Strength")
@Description(value={"The vertical strength of a Citizen NPC's forcefield."})
@Since(value={"1.2.1-b1"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"set citizen forcefield vertical strength of all npcs to 10"})
public class ExprForcefieldVertStrength
extends SimplePropertyExpression<NPCForcefield, Number> {
    @Nullable
    public Number convert(NPCForcefield forcefield) {
        return forcefield.getVertStrength();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof Number) {
            Number vertStrength = (Number)delta[0];
            NPCForcefield forcefield = (NPCForcefield)this.getExpr().getSingle(event);
            if (forcefield != null) {
                forcefield.setVertStrength(vertStrength.doubleValue());
            }
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "citizen forcefield vertical strength";
    }

    static {
        ExprForcefieldVertStrength.registerDefault(ExprForcefieldVertStrength.class, Number.class, (String)"forcefield vertical strength", (String)"npcforcefield");
    }
}

