/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.hitbox;

import au.nagasonic.skonic.elements.hitbox.NPCHitbox;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Hitbox")
@Description(value={"The hitbox of a Citizens NPC"})
@Examples(value={"set {_box} to hitbox of npc with id 3"})
@Since(value={"1.2.2-b1"})
@RequiredPlugins(value={"Citizens"})
public class ExprCitizenHitbox
extends SimplePropertyExpression<NPC, NPCHitbox> {
    @Nullable
    public NPCHitbox convert(NPC npc) {
        return NPCHitbox.fromNPC(npc);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{NPCHitbox.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof NPCHitbox) {
            NPCHitbox box = (NPCHitbox)delta[0];
            NPC npc = (NPC)this.getExpr().getSingle(event);
            if (npc != null) {
                box.setHitbox(npc);
            }
        }
    }

    @NotNull
    public Class<? extends NPCHitbox> getReturnType() {
        return NPCHitbox.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "citizen hitbox";
    }

    static {
        ExprCitizenHitbox.register(ExprCitizenHitbox.class, NPCHitbox.class, (String)"(citizen|npc) hitbox", (String)"npc");
    }
}

