/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.hitbox;

import au.nagasonic.skonic.elements.hitbox.CitizenHitboxCreateEvent;
import au.nagasonic.skonic.elements.hitbox.NPCHitbox;
import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SectionExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import java.util.List;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Hitbox With")
@Description(value={"A Citizen Hitbox with the given components.", "Scale is a multiplier for the hitbox. For example, if the width was 1 and the height was 2, then if the scale was 2, the hitbox's effective dimenstions would be 2 width and 4 height.", "Default values are:", "- Scale: 1", "- Width: 1", "- Height: 2"})
@Since(value={"1.2.2-b1"})
@Examples(value={"set {_hitbox} to a hitbox with scale 1, width 2 and height 4", "", "set {_box} to a hitbox:", "\tset hitbox scale to 1", "\tset hitbox width to 1", "\tset hitbox height to 2"})
@RequiredPlugins(value={"Citizens"})
public class ExprHitbox
extends SectionExpression<NPCHitbox> {
    private Trigger trigger;
    private Expression<Number> scaleExpr;
    private Expression<Number> widthExpr;
    private Expression<Number> heightExpr;

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean delayed, SkriptParser.ParseResult result, @Nullable SectionNode node, @Nullable List<TriggerItem> triggerItems) {
        if (node != null) {
            this.trigger = this.loadCode(node, "create hitbox", null, new Class[]{CitizenHitboxCreateEvent.class});
        }
        this.scaleExpr = exprs[0];
        this.widthExpr = exprs[1];
        this.heightExpr = exprs[2];
        return true;
    }

    protected NPCHitbox @Nullable [] get(Event event) {
        NPCHitbox hitbox = new NPCHitbox(this.scaleExpr.getSingle(event) == null ? 1.0f : ((Number)this.scaleExpr.getSingle(event)).floatValue(), this.widthExpr.getSingle(event) == null ? 1.0f : ((Number)this.widthExpr.getSingle(event)).floatValue(), this.heightExpr.getSingle(event) == null ? 2.0f : ((Number)this.heightExpr.getSingle(event)).floatValue());
        if (this.trigger != null) {
            CitizenHitboxCreateEvent createEvent = new CitizenHitboxCreateEvent(hitbox);
            Variables.withLocalVariables((Event)event, (Event)createEvent, () -> TriggerItem.walk((TriggerItem)this.trigger, (Event)createEvent));
        }
        return new NPCHitbox[]{hitbox};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends NPCHitbox> getReturnType() {
        return NPCHitbox.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "hitbox with scale: " + this.scaleExpr.toString(event, debug) + " with width: " + this.widthExpr.toString(event, debug) + " with height: " + this.heightExpr.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprHitbox.class, NPCHitbox.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] hitbox [with scale %number%[,| and]] [[with] width %number%[,| and]] [[with] height %number%]"});
        EventValues.registerEventValue(CitizenHitboxCreateEvent.class, NPCHitbox.class, CitizenHitboxCreateEvent::getHitbox);
    }
}

