/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.items.heads;

import au.nagasonic.skonic.Skonic;
import au.nagasonic.skonic.elements.skins.Skin;
import au.nagasonic.skonic.elements.util.HeadUtils;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="Head from Skin")
@Description(value={"Gets a head by skin."})
@Since(value={"1.0.7"})
@Examples(value={"set helmet of player to head from player's skin"})
public class ExprHeadFromSkin
extends SimpleExpression<ItemStack> {
    private Expression<Skin> skinExpr;

    @Nullable
    protected ItemStack[] get(Event e) {
        Skin skin = (Skin)this.skinExpr.getSingle(e);
        if (skin != null) {
            String value = skin.getTexture();
            if (value != null) {
                ItemStack item = HeadUtils.headFromBase64(value);
                if (item != null) {
                    return new ItemStack[]{item};
                }
                Skonic.log(Level.WARNING, "Returned item is null, this could mean that the inputted value does not link to a skin.");
            } else {
                Skonic.log(Level.WARNING, "Skin's value is null, this most likely means that the skin is set up wrong, or is empty.");
            }
        } else {
            Skonic.log(Level.WARNING, "Skin is null, this basically means that it is an empty variable or doesn't exist.");
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "head from skin " + this.skinExpr.toString(e, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.skinExpr = exprs[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprHeadFromSkin.class, ItemStack.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(head|skull) from %skin%"});
    }
}

