/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.items.heads;

import au.nagasonic.skonic.elements.util.HeadUtils;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Head from URL")
@Description(value={"Gets a head by URL"})
@Since(value={"1.0.4"})
@Examples(value={"set {_melon} to head from url \"http://textures.minecraft.net/texture/9636dee806ba47a2c40e95b57a12f37de6c2e677f2160132a07e24eeffa6\""})
public class ExprHeadFromURL
extends SimpleExpression<ItemStack> {
    private Expression<String> url;

    public boolean init(Expression<?>[] exprs, int i, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.url = exprs[0];
        return true;
    }

    @Nullable
    protected ItemStack[] get(Event event) {
        String url = (String)this.url.getSingle(event);
        if (url != null) {
            ItemStack item = HeadUtils.headFromUrl(url);
            if (item != null) {
                return new ItemStack[]{item};
            }
            return null;
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "head from url " + this.url.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprHeadFromURL.class, ItemStack.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(head|skull) from url %string%"});
    }
}

