/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.items.heads;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;

@Name(value="Owner of Head")
@Description(value={"Gets the owner of a player head.Will only work if the head is from a player."})
@Since(value={"1.0.4"})
@Examples(value={"broadcast owner of player's tool"})
public class ExprOwnerOfHead
extends SimplePropertyExpression<ItemStack, Player> {
    @Nullable
    public Player convert(ItemStack from) {
        if (from != null && from.getType() == Material.PLAYER_HEAD) {
            SkullMeta meta = (SkullMeta)from.getItemMeta();
            Player player = (Player)meta.getOwningPlayer();
            if (player != null) {
                return player;
            }
            return null;
        }
        return null;
    }

    protected String getPropertyName() {
        return null;
    }

    public Class<? extends Player> getReturnType() {
        return null;
    }

    static {
        ExprOwnerOfHead.register(ExprOwnerOfHead.class, Player.class, (String)"owner", (String)"itemstack");
    }
}

